## Spike Calibration: Bridging the Gap between ANNs and SNNs in ANN-SNN Conversion

This directory contains the code of this paper.
## Dependency
The major dependencies of this code are list as below. 
```
torch==1.12.1
tqdm==4.63.0
numpy==1.21.5
torchvision==0.13.1
spikingjelly==0.0.0.0.1
```
## Environment
* System: Ubuntu 20.04.1 LTS (5.15.0-46-generic x86_64)
* GPU: NVIDIA GeForce RTX 3090
* CPU: Intel(R) Xeon(R) Silver 4210R CPU @ 2.40GHz

## Usage
Get info :
```python
python main.py --help
```

If you have already obtained a pretrained QCFS ANN model, you can consider executing the code like the following ways (for example: ImageNet) :
```python
python /home/user/main.py --dataset ImageNet --load_model_name /home/user/model/QCFS_ImageNet_vgg16_L16 --net_arch vgg16 --batchsize 5 --CUDA_VISIBLE_DEVICE 1 --L 16 --presim_len 8 --sim_len 16
```

If you want to train a QCFS ANN model directly, you can consider executing the code like the following ways :
```python
python /home/user/main.py --dataset CIFAR100 --net_arch vgg16 --L 4 --trainann_epochs 300 --batchsize 100 --CUDA_VISIBLE_DEVICE 7 --presim_len 4 --sim_len 32 --direct_training --savedir /home/user/model/ 
```

